<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */
    
    session_start();
    include "../../include/costanti.php";
    include "../../include/util.php";
    include "../../gUtil/DbManager.php";
    include "../../gUtil/GestoreUpload.php";
    include "../../gUtil/ControlloreStringhe.php";
    include "../../gUtil/ElaboratoreImmagini.php";
    include "../../gUtil/GestoreTraduzioni.php";
    include "../../classi/GeneratoreUrl.php";
    include "../../classi/ecommerce/Prodotto.php";
    include "../../classi/Immagine.php";
    include "../../classi/FileScaricabile.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb      = new DbManager($costantiDatabase);
    $datiGeecomCms = $geecomDb->leggiSingolaRiga("geec_prodotti",1);
    $impostazioniEcommerce = $geecomDb->leggiSingolaRiga("geecEc_impostazioni",1);      
    $urlAreaAmministrativa = GeneratoreUrl::creaUrlAreaAmministrativa(recuperaImpostazioni($geecomDb), $datiGeecomCms);
         
    if(isset($_GET["operazione"])) {
	$operazione = filter_input(INPUT_GET, "operazione", FILTER_SANITIZE_STRING);
	$idProdotto = filter_input(INPUT_GET, "id", FILTER_SANITIZE_NUMBER_INT);
    }
    else {
	$operazione = filter_input(INPUT_POST, "operazione", FILTER_SANITIZE_STRING);
	$idProdotto = (isset($_POST["id"])) ? filter_input(INPUT_POST, "id", FILTER_SANITIZE_NUMBER_INT) : 0;
    }
    $prodotto = new Prodotto($geecomDb, $idProdotto);
    
    switch($operazione) {
        case 'elimina':
            $prodotto->elimina();
            echo "ok";
            break;
        case 'eliminaImmagineProdotto':
            $idImmagine = filter_input(INPUT_POST, "idImmagine", FILTER_SANITIZE_NUMBER_INT);
            $prodotto->eliminaImmagine($idImmagine);
            echo"ok";
        case 'crea':
            // controllo se è stato inserito codice dannoso, se si non crea l'articolo
            if(ControlloreStringhe::rilevaJavascript($_POST["nome"]) || ControlloreStringhe::rilevaJavascript($_POST["descrizione"]) || ControlloreStringhe::rilevaMysql($_POST["nome"]) || ControlloreStringhe::rilevaMysql($_POST["descrizione"])) {
                header("Location: ../../pagina.php?id=4&status=400");
            }
            else {
                $nome = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
                $pubblicato = (isset($_POST["pubblicato"]) && $_POST["pubblicato"]=="si") ? "si" : "no";
                $iva        = isset($_POST["iva"]) ? filter_input(INPUT_POST,"iva",FILTER_SANITIZE_NUMBER_INT) : 0;
                $prodottoInesauribile = (isset($_POST["prodottoInesauribile"]) && $_POST["prodottoInesauribile"]=="si") ? "si" : "no";

                $prodotto->setCodiceProdotto(filter_input(INPUT_POST,"codiceProdotto",FILTER_SANITIZE_STRING));
                $prodotto->setIdFornitore(0);
                $prodotto->setProdottoRiferimento(0);
                $prodotto->setLingua("italiano");
                $prodotto->setProdottoPadre(0);
                $prodotto->setEan(filter_input(INPUT_POST,"ean",FILTER_SANITIZE_STRING));
                $prodotto->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
                $prodotto->setAlias(generaAlias($geecomDb, $nome,"geecEc_prodotti","nome"));
                $prodotto->setImmagineInEvidenza("");
                $prodotto->setTemplate(filter_input(INPUT_POST,"template",FILTER_SANITIZE_STRING));
                $prodotto->setPubblicato($pubblicato);
                $prodotto->setUsaVariazioni(filter_input(INPUT_POST,"usaVariazioni",FILTER_SANITIZE_STRING));
                $prodotto->setCategoria(filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT));
                $prodotto->setDisponibilita(filter_input(INPUT_POST,"disponibilita",FILTER_SANITIZE_NUMBER_INT));
                $prodotto->setProdottoInesauribile($prodottoInesauribile);
                $prodotto->setPrezzo(filter_input(INPUT_POST,"prezzo",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
                $prodotto->setPrezzoAcquisto(filter_input(INPUT_POST,"prezzoAcquisto",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
                $prodotto->setPrezzoOfferta(filter_input(INPUT_POST,"prezzoOfferta",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
                $prodotto->setIva($iva);
                $prodotto->setPrezzoUnitario(filter_input(INPUT_POST,"prezzoUnitario",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
                $prodotto->setUnita(filter_input(INPUT_POST,"unita",FILTER_SANITIZE_STRING));
                $prodotto->setMinimoAcquisto(filter_input(INPUT_POST,"minimoAcquisto",FILTER_SANITIZE_NUMBER_INT));
                $prodotto->setMetaDescrizione(filter_input(INPUT_POST,"metaDescrizione",FILTER_SANITIZE_STRING));
                $prodotto->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_STRING));
                $prodotto->setTestoDettagli(filter_input(INPUT_POST,"testoDettagli",FILTER_SANITIZE_STRING));
                $prodotto->setMarca(filter_input(INPUT_POST,"marca",FILTER_SANITIZE_STRING));
                $prodotto->setModello(filter_input(INPUT_POST,"modello",FILTER_SANITIZE_STRING));
                $prodotto->setFormato(filter_input(INPUT_POST,"formato",FILTER_SANITIZE_STRING));
                $prodotto->setMateriale(filter_input(INPUT_POST,"materiale",FILTER_SANITIZE_STRING));
                $prodotto->setCapacità(filter_input(INPUT_POST,"capacita",FILTER_SANITIZE_STRING));
                $prodotto->setColore(filter_input(INPUT_POST,"colore",FILTER_SANITIZE_STRING));
                $prodotto->setLarghezza(filter_input(INPUT_POST,"larghezza",FILTER_SANITIZE_STRING));
                $prodotto->setAltezza(filter_input(INPUT_POST,"altezza",FILTER_SANITIZE_STRING));
                $prodotto->setProfondita(filter_input(INPUT_POST,"profondita",FILTER_SANITIZE_STRING));
                $prodotto->setPeso(filter_input(INPUT_POST,"peso",FILTER_SANITIZE_STRING));
                $prodotto->setPesoVolumetrico(filter_input(INPUT_POST,"pesoVolumetrico",FILTER_SANITIZE_STRING));
                $prodotto->setTipoProdotto(filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_STRING));
                $prodotto->setNumeroVisite(0);
                $prodotto->setNumeroVendite(0);
                $prodotto->setAbilitaCommenti("no");
                $prodotto->setDataInserimento(date("Y-m-d"));
                $idProdotto = $prodotto->crea();

                if($prodotto->getTipoProdotto()=="sistemazioneTuristica") {
		        header("Location: $urlAreaAmministrativa/componenti/hotelManager/creaSistemazione.php?id=$idProdotto&status=275");
                }
                else {
		        header("Location: $urlAreaAmministrativa/componenti/ecommerce/creaProdotto.php?id=$idProdotto&status=275");
                }
            }
            break;
        case 'modifica':
            $nome = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $pubblicato           = (isset($_POST["pubblicato"]) && $_POST["pubblicato"]=="si") ? "si" : "no";
            $iva        = isset($_POST["iva"]) ? filter_input(INPUT_POST,"iva",FILTER_SANITIZE_NUMBER_INT) : 0;
            $prodottoInesauribile = (isset($_POST["prodottoInesauribile"]) && $_POST["prodottoInesauribile"]=="si") ? "si" : "no";

            $prodotto->caricaDatiDalDatabase();
            $prodotto->setCodiceProdotto(filter_input(INPUT_POST,"codiceProdotto",FILTER_SANITIZE_STRING));
            $prodotto->setIdFornitore(0);
            $prodotto->setLingua("italiano");
            $prodotto->setEan(filter_input(INPUT_POST,"ean",FILTER_SANITIZE_STRING));
            $prodotto->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $prodotto->setAlias(filter_input(INPUT_POST,"alias",FILTER_SANITIZE_ADD_SLASHES));
            $prodotto->setImmagineInEvidenza("");
            $prodotto->setTemplate(filter_input(INPUT_POST,"template",FILTER_SANITIZE_STRING));
            $prodotto->setPubblicato($pubblicato);
            $prodotto->setUsaVariazioni(filter_input(INPUT_POST,"usaVariazioni",FILTER_SANITIZE_STRING));
            $prodotto->setCategoria(filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT));
            $prodotto->setDisponibilita(filter_input(INPUT_POST,"disponibilita",FILTER_SANITIZE_NUMBER_INT));
            $prodotto->setProdottoInesauribile($prodottoInesauribile);
            $prodotto->setPrezzo(filter_input(INPUT_POST,"prezzo",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
            $prodotto->setPrezzoAcquisto(filter_input(INPUT_POST,"prezzoAcquisto",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
            $prodotto->setPrezzoOfferta(filter_input(INPUT_POST,"prezzoOfferta",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
            $prodotto->setIva($iva);
            $prodotto->setPrezzoUnitario(filter_input(INPUT_POST,"prezzoUnitario",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
            $prodotto->setUnita(filter_input(INPUT_POST,"unita",FILTER_SANITIZE_STRING));
            $prodotto->setMinimoAcquisto(filter_input(INPUT_POST,"minimoAcquisto",FILTER_SANITIZE_NUMBER_INT));
            $prodotto->setMetaDescrizione(filter_input(INPUT_POST,"metaDescrizione",FILTER_SANITIZE_STRING));
            $prodotto->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $prodotto->setTestoDettagli(filter_input(INPUT_POST,"testoDettagli",FILTER_SANITIZE_ADD_SLASHES));
            $prodotto->setMarca(filter_input(INPUT_POST,"marca",FILTER_SANITIZE_STRING));
            $prodotto->setModello(filter_input(INPUT_POST,"modello",FILTER_SANITIZE_STRING));
            $prodotto->setFormato(filter_input(INPUT_POST,"formato",FILTER_SANITIZE_STRING));
            $prodotto->setMateriale(filter_input(INPUT_POST,"materiale",FILTER_SANITIZE_STRING));
            $prodotto->setCapacità(filter_input(INPUT_POST,"capacita",FILTER_SANITIZE_STRING));
            $prodotto->setColore(filter_input(INPUT_POST,"colore",FILTER_SANITIZE_STRING));
            $prodotto->setLarghezza(filter_input(INPUT_POST,"larghezza",FILTER_SANITIZE_STRING));
            $prodotto->setAltezza(filter_input(INPUT_POST,"altezza",FILTER_SANITIZE_STRING));
            $prodotto->setProfondita(filter_input(INPUT_POST,"profondita",FILTER_SANITIZE_STRING));
            $prodotto->setPeso(filter_input(INPUT_POST,"peso",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
            $prodotto->setPesoVolumetrico(filter_input(INPUT_POST,"pesoVolumetrico",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
            $prodotto->setTipoProdotto(filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_STRING));
            $prodotto->setAbilitaCommenti("no");
            $prodotto->setDataInserimento(date("Y-m-d"));
            $prodotto->salvaModifiche();

            if($prodotto->getTipoProdotto()=="sistemazioneTuristica") {
                header("Location: $urlAreaAmministrativa/componenti/hotelManager/creaSistemazione.php?id=$idProdotto&status=275");
            }
            else {
                header("Location: $urlAreaAmministrativa/componenti/ecommerce/creaProdotto.php?id=$idProdotto&status=275");
            }
            break;
        case 'duplica':
            $idProdottoDuplicato = $prodotto->duplica();
            header("Location: ../../".str_replace("../","",$datiGeecomCms["percorso"])."/componenti/ecommerce/creaProdotto.php?id=$idProdottoDuplicato&status=280");
            break;
        case 'traduci':
            $lingua = filter_input(INPUT_GET, "lingua",FILTER_SANITIZE_STRING);
            $idProdottoTradotto = $prodotto->traduci($lingua);
            header("Location: ../../".str_replace("../","",$datiGeecomCms["percorso"])."/componenti/ecommerce/creaProdotto.php?id=$idProdottoTradotto&status=320");
            break;
        case 'aggiungiFotoProdotto':
            $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../immagini/ecommerce", 0, "");
            $esitoUpload  = $gestoreUpload->salvaFile();

            $queryPosizioneUltimaImmagine = "SELECT * FROM geec_immagini WHERE tipoImmagine LIKE 'immagineProdotto' AND idContenuto=$idProdotto ORDER BY posizione DESC LIMIT 1";
            $risUltimaImmagine = $geecomDb->eseguiQueryLettura($queryPosizioneUltimaImmagine);
            if($risUltimaImmagine->num_rows>0) {
                $ultimaImmagine = $risUltimaImmagine->fetch_assoc();
                $posizioneImmagine = $ultimaImmagine["posizione"]+1;
            }
            else {
                $posizioneImmagine = 1;
            }

            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../../","",$esitoUpload["percorso"]);
                    $queryCreaImmagine = "INSERT INTO geec_immagini VALUES(NULL, $idProdotto, 'immagineProdotto', '$percorsoFoto','','$posizioneImmagine')";
                    $geecomDb->eseguiQueryScrittura($queryCreaImmagine);

                    // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                    if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                        $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                        if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                            $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                        }
                    }
                }
            }
            else {
                foreach($esitoUpload["elencoRisultati"] as $risultato) {
                    if($risultato["percorso"]!="") {
                        $percorsoFoto = str_replace("../../","",$risultato["percorso"]);
                        $queryCreaImmagine = "INSERT INTO geec_immagini VALUES(NULL, $idProdotto, 'immagineProdotto', '$percorsoFoto','','$posizioneImmagine')";
                        $geecomDb->eseguiQueryScrittura($queryCreaImmagine);
                        $posizioneImmagine++;

                        // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                        if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                            $elaboratoreImmagini = new ElaboratoreImmagini($risultato["percorso"]);
                            if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $risultato["percorso"]);
                            }
                        }
                    }
                }
            }
            echo"ok";
            break;
        case 'modificaPosizioneImmagineProdotto':
            $idImmagine     = filter_input(INPUT_POST,"idImmagine",FILTER_SANITIZE_NUMBER_INT);
            $nuovaPosizione = filter_input(INPUT_POST,"posizione",FILTER_SANITIZE_NUMBER_INT);
            $prodotto->modificaPosizioneImmagine($idImmagine,$nuovaPosizione);
            echo "ok";
            break;
        case 'stampaFotoProdotto':
            $prodotto->stampaImmaginiProdotto();
            break;
        case 'modificaImmagineInEvidenza':
            $immagine = filter_input(INPUT_POST,"percorsoImmagine",FILTER_SANITIZE_STRING);
            $prodotto->caricaDatiDalDatabase();
            $prodotto->setImmagineInEvidenza($immagine);
            $prodotto->salvaModifiche();
            echo"ok";
        case 'modificaImmagineInEvidenzaConPercorso':
            $percorsoFoto = filter_input(INPUT_POST,"percorso",FILTER_SANITIZE_STRING);
            $prodotto->modificaFoto($percorsoFoto);
            echo "ok";
            break;
        case 'eliminaImmagineInEvidenza':
            $prodotto->modificaFoto("");
            echo"ok";
            break;
        case 'aggiungiAttributo':
            $nome    = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $valori  = filter_input(INPUT_POST,"valori",FILTER_SANITIZE_STRING);
            $costi   = filter_input(INPUT_POST,"costi",FILTER_SANITIZE_STRING);
            $prodotto->aggiungiAttributo($nome,$valori,$costi);
            echo"ok";
            break;
        case 'modificaAttributo':
            $id      = filter_input(INPUT_POST,"idAttributo",FILTER_SANITIZE_NUMBER_INT);
            $nome    = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $valori  = filter_input(INPUT_POST,"valori",FILTER_SANITIZE_STRING);
            $costi   = filter_input(INPUT_POST,"costi",FILTER_SANITIZE_STRING);
            $prodotto->modificaAttributo($id,$nome,$valori,$costi);
            echo"ok";
            break;
        case 'eliminaAttributo':
            $idAttributo = filter_input(INPUT_POST,"idAttributo",FILTER_SANITIZE_NUMBER_INT);
            $prodotto->eliminaAttributo($idAttributo);
            echo "ok";
            break;
        case 'stampaAttributi':
            $prodotto->stampaAttributi();
            break;
        case 'creaTutteLeVariazioni':
            $prodotto->creaTutteLeVariazioni();
            echo "ok";
            break;
        case 'creaVariazioni':
            $idAttributo = filter_input(INPUT_POST,"idAttributo",FILTER_SANITIZE_NUMBER_INT);
            $prodotto->creaVariazioni($idAttributo);
            echo "ok";
            break;
        case 'stampaVariazioni':
            $prodotto->stampaVariazioni();
            break;
        case 'modificaVariazione':
            $id              = filter_input(INPUT_POST,"idVariazione",FILTER_SANITIZE_NUMBER_INT);
            $codiceProdotto  = filter_input(INPUT_POST,"codiceVariazione",FILTER_SANITIZE_STRING);
            $nome     	 = filter_input(INPUT_POST,"nomeVariazione",FILTER_SANITIZE_STRING);
            $costo    	 = filter_input(INPUT_POST,"costoVariazione",FILTER_SANITIZE_STRING);
            $quantita 	 = filter_input(INPUT_POST,"quantitaVariazione",FILTER_SANITIZE_STRING);
            $prodotto->modificaVariazione($id,$codiceProdotto,$nome,$costo,$quantita);
            echo"ok";
            break;
        case 'eliminaVariazione':
            $idVariazione = filter_input(INPUT_POST,"idVariazione",FILTER_SANITIZE_NUMBER_INT);
            $geecomDb->eseguiQueryCancellazione("geecEc_variazioniProdotto",$idVariazione);

            $numeroVariazioniProdotto = $geecomDb->contaRigheTabella("geecEc_variazioniProdotto",array("idProdotto"=>$prodotto->getId()));
            if($numeroVariazioniProdotto==0) {
                $geecomDb->eseguiQueryScrittura("UPDATE geecEc_prodotti SET usaVariazioni='no' WHERE id={$prodotto->getId()}");
            }
            echo"ok";
            break;
        case 'aggiornaUsaVariazioni':
            $usaVariazioni = filter_input(INPUT_POST,"usaVariazioni",FILTER_SANITIZE_STRING);
            $prodotto->aggiornaUsaVariazioni($usaVariazioni);
            echo"ok";
            break;
        case 'eliminaImmagineSezione':
            $idSezione = filter_input(INPUT_POST,"idSezione",FILTER_SANITIZE_NUMBER_INT);
            $prodotto->eliminaImmagineSezioneComponente($idSezione);
            echo "ok";
            break;
        case 'aggiungiComponentePagina':
            $idProdotto     = filter_input(INPUT_GET,'idPagina',FILTER_SANITIZE_NUMBER_INT);
            $idComponente = filter_input(INPUT_GET,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            $tipoElemento = filter_input(INPUT_GET,'tipoElemento',FILTER_SANITIZE_STRING);
            
            //recupero l'ultima posizione occupata nel pannello laterale
            // le occorrenze di geecB_composizionePagine prese in considerazione sono solo quelle di tipo contenuto (devono essere escluse quelle delle sezioni multiple)
            $queryUltimaPosizione = "SELECT posizione FROM geecB_composizionePagine WHERE idPagina=$idProdotto AND tipoElemento LIKE '$tipoElemento' ORDER BY posizione DESC LIMIT 1";
            $risPosizione = $geecomDb->eseguiQueryLettura($queryUltimaPosizione);
            $ultimaPosizione = $risPosizione->fetch_assoc();
            $posizione = $ultimaPosizione["posizione"]+1;
            
            $idElemento = creaComponente($geecomDb,$idComponente, $idProdotto);
            
            $queryUtimaSezione  = "SELECT * FROM geecB_composizionePagine ORDER BY id DESC";
            $risSezione         = $geecomDb->eseguiQueryLettura($queryUtimaSezione);
            $ultimaSezione      = $risSezione->fetch_assoc();
            $progressivoSezione = $ultimaSezione["id"] +1;
            $idSezione  = "sezione$progressivoSezione";
            
            // creo l'occorrenza del componente con i dati passati in input
            // la tabella geecB_composizionePagine dispone di altri campi che non vengono inseriti 
            // qui perché vengono inizializzati con i valori di default
            $queryAggiornamentoProdotto = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`,`idPagina`,`tipoElemento`,`idElemento`, `posizione`,`idSezione`) "
                    . "VALUES(NULL,'$idComponente',$idProdotto,'$tipoElemento',$idElemento,$posizione,'$idSezione')";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);
            
            header("Location: $urlAreaAmministrativa/componenti/ecommerce/creaProdotto.php?id=$idProdotto&status=350");
            break;
        case 'modificaComponente':
            $id = filter_input(INPUT_POST, "id", FILTER_SANITIZE_NUMBER_INT);
            $idComponente = filter_input(INPUT_POST, "idComponente", FILTER_SANITIZE_NUMBER_INT);
            $datiComponente = $geecomDb->leggiSingolaRiga("geecB_composizionePagine", $id); // recupero i dati sul componente, perché ci sono componenti che necessitano di azioni particolari

            $classeSezione = filter_input(INPUT_POST, "classeSezione", FILTER_SANITIZE_STRING);
            $modificaTesto = "testo='".$geecomDb->escapeString($_POST['testo'])."',";

            $animazione   = (isset($_POST['animazione'])) ? filter_input(INPUT_POST, "animazione", FILTER_SANITIZE_STRING) : "";
            $altreOpzioni = (isset($_POST['opzioneClasseColonne'])) ? "opzioneClasseColonne=".filter_input(INPUT_POST, "opzioneClasseColonne", FILTER_SANITIZE_STRING).";" : "";
            if(isset($_POST["opzioneTagH"])) {
                $altreOpzioni .= "opzioneTagH=".filter_input(INPUT_POST, "opzioneTagH", FILTER_SANITIZE_STRING).";";
            }
            if(isset($_POST["opzioneSeparatore"])) {
                $altreOpzioni .= "opzioneSeparatore=".filter_input(INPUT_POST, "opzioneSeparatore", FILTER_SANITIZE_STRING).";";
            }
            if(isset($_POST["opzioneAllineamento"])) {
                $altreOpzioni .= "opzioneAllineamento=".filter_input(INPUT_POST, "opzioneAllineamento", FILTER_SANITIZE_STRING).";";
            }
            if(isset($_POST["opzioneDimensioniIcona"])) {
                $altreOpzioni .= "opzioneDimensioniIcona=".filter_input(INPUT_POST, "opzioneDimensioniIcona", FILTER_SANITIZE_STRING).";";
            }
            if(isset($_POST["opzioneStile"])) {
                $altreOpzioni .= "opzioneStile=".filter_input(INPUT_POST, "opzioneStile", FILTER_SANITIZE_STRING).";";
            }
            
            // questo codice serve per modificare la didascalia dell'immagine
            if($idComponente==17) {
                $immagine = new Immagine($geecomDb, $datiComponente["idElemento"]);
                $immagine->caricaDatiDalDatabase();
                $immagine->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_STRING));
                $immagine->modifica();
            }

            if(isset($_FILES['file'])) {
                // a seconda che si tratti del componente audio o del componente immagine 
                // viene creato il percorsoBase e vengono definiti i tipi di file ammessi
                if($idComponente==17) { // componente immagine
                    $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
                    $percorsoBase = "immagini/altro/";
                }
                else if($idComponente==36) { // componente Singola risorsa
                    $tipiFileAmmessi = array("text/plain","application/pdf","application/msword","application/vnd.oasis.opendocument.text","","image/png","image/jpeg","image/webp","image/gif");
                    $percorsoBase = "file/risorse/";
                }
                else {
                    $tipiFileAmmessi = array("audio/mpeg","application/ogg");
                    $percorsoBase = "file/audio/";
                }

                if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $modificaTesto ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)

                    $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../$percorsoBase", 0, "");
                    $esitoUpload  = $gestoreUpload->salvaFile();
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFile  = str_replace("../../","",$esitoUpload["percorso"]);
                        $modificaTesto ="testo='$percorsoFile', ";

                        if($idComponente==17) { // se è il componente immagine
                            $immagine = new Immagine($geecomDb, $datiComponente["idElemento"]);
                            $immagine->caricaDatiDalDatabase();
                            $immagine->setPercorso($percorsoFile);
                            $immagine->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_STRING));
                            $immagine->modifica();

                            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                                }
                            }
                        }
                        
                        if($idComponente==36) { // se il componente è risorsa singola devo aggiornare anche la risorsa 
                            $nomeRisorsa = filter_input(INPUT_POST, "nomeRisorsa", FILTER_SANITIZE_STRING);

                            $queryModificaRisorsa = "UPDATE geecB_risorse SET percorso='$percorsoFile', nome='$nomeRisorsa' WHERE id={$datiComponente["idElemento"]}";
                            $geecomDb->eseguiQueryScrittura($queryModificaRisorsa);
                        }
                    }
                    else {
                        $modificaTesto = "";
                    }
                }
            }
            
            //aggiorno le impostazioni con i dati passati in input
            if($idComponente==36) {
                $nomeRisorsa = filter_input(INPUT_POST, "nomeRisorsa", FILTER_SANITIZE_STRING);
                $altreOpzioni.="nomeRisorsa=$nomeRisorsa;";
                
                $percorso ="$percorsoBase/".str_replace(array("'","\""),"",$_FILES['file']['name']);
                $queryModificaRisorsa = "UPDATE geecB_risorse SET nome='$nomeRisorsa' WHERE id={$datiComponente["idElemento"]}";
                $geecomDb->eseguiQueryScrittura($queryModificaRisorsa);
            }
            
            $queryAggiornamentoProdotto = "UPDATE geecB_composizionePagine SET $modificaTesto animazione='$animazione', altreOpzioni='$altreOpzioni' WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);
            
            header("Location: $urlAreaAmministrativa/componenti/ecommerce/creaProdotto.php?id={$datiComponente["idPagina"]}&status=360");
            break;
        case 'duplicaComponente':
            $idComponente = filter_input(INPUT_POST,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            $prodotto->duplicaComponente($idComponente);
            
            $query    = "SELECT cp.*, c.tipo, c.tabellaRiferimento FROM geecB_composizionePagine AS cp JOIN geecB_componenti AS c ON cp.idComponente = c.id WHERE cp.id={$idComponente}";
            $risQuery = $geecomDb->eseguiQueryLettura($query);
            $datiComponente = $risQuery->fetch_assoc();
            
            if($datiComponente["tipo"]=="componenteDinamico" || $datiComponente["tipo"]=="componenteStrutturaPagina") { // in questo caso il messaggio deve essere ricaricata la pagina creaContenuto.php per generare le modal
                echo "ok,ricarica";
            }
            else {
                echo "ok";
            }
            break;
        case 'modificaOpzioniSezione':
            $id             = filter_input(INPUT_POST,'idSezioneDaModificare',FILTER_SANITIZE_NUMBER_INT);
            $idSezione      = filter_input(INPUT_POST,'idSezione',FILTER_SANITIZE_STRING);
            $classeSezione  = filter_input(INPUT_POST,'classeSezione',FILTER_SANITIZE_STRING);
            $margineSezione = filter_input(INPUT_POST,'margineSezione',FILTER_SANITIZE_STRING);
            $paddingSezione = filter_input(INPUT_POST,'paddingSezione',FILTER_SANITIZE_STRING);
            $aTuttaLarghezza= filter_input(INPUT_POST,'sezioneATuttaLarghezza',FILTER_SANITIZE_STRING);
            $coloreSfondo   = filter_input(INPUT_POST,'coloreSfondo',FILTER_SANITIZE_STRING);
            
            if(isset($_FILES['file'])) {

                if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $modificaTesto ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)
                    $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
                    $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../immagini/altro/", 0, "");
                    $esitoUpload  = $gestoreUpload->salvaFile();
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFile  = str_replace("../../","",$esitoUpload["percorso"]);
                        
                        // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                        if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                            $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                            if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                            }
                        }
                    }
                    else {
                        $percorsoFile = "";
                    }
                }
            }
            
            if(isset($_FILES['video'])) {
                if($_FILES['video']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $percorsoFileVideo ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)
                    $tipiFileAmmessi = array("video/mp4","video/x-m4v");
                    $gestoreUpload = new GestoreUpload("video", $tipiFileAmmessi, 8, "../../file/video/", 0, "");
                    $esitoUpload  = $gestoreUpload->salvaFile();
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFileVideo  = str_replace("../../","",$esitoUpload["percorso"]);
                    }
                    else {
                        $percorsoFileVideo = "";
                    }
                }
            }
            
            $prodotto->modificaOpzioniSezioneComponente($id, $idSezione, $classeSezione, $aTuttaLarghezza, $margineSezione, $paddingSezione,$coloreSfondo,$percorsoFile,$percorsoFileVideo);
            $prodotto->aggiornaCssGenerato();

            header("Location: $urlAreaAmministrativa/componenti/ecommerce/creaProdotto.php?id={$prodotto->getId()}&status=370");
            break;
        case 'cambiaIdElemento':
            $id         = filter_input(INPUT_GET,'id',FILTER_SANITIZE_NUMBER_INT);
            $idElemento = filter_input(INPUT_GET,'idElemento',FILTER_SANITIZE_NUMBER_INT);
            $query = "UPDATE geecB_composizionePagine SET idElemento=$idElemento WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($query);
            echo "ok";
            break;
        case 'modificaPosizioneComponente':
            $idComponente = filter_input(INPUT_POST,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            $posizione    = filter_input(INPUT_POST,'posizione',FILTER_SANITIZE_NUMBER_INT);
            
            $prodotto->caricaDatiDalDatabase();
            $prodotto->modificaPosizioneComponente($idComponente,$posizione);
            echo "ok";
            break;
         case 'stampaCostoVariante':
            $prodotto->caricaDatiDalDatabase();
            $lingua = $prodotto->getLingua();
            
            $gestoreTraduzioni = new GestoreTraduzioni("../../localizzazione", [$lingua]);
            $gestoreTraduzioni->caricaTraduzioni();
            
            if($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA esclusa") {
            	$suffissoIva = $gestoreTraduzioni->traduci("+ IVA",$prodotto->getLingua());
            }
            else if($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") {
            	$suffissoIva = $gestoreTraduzioni->traduci("IVA inclusa",$prodotto->getLingua());
            }
            else {
            	$suffissoIva = "";
            }
            
            $idVariante     = filter_input(INPUT_POST, "idVariante",FILTER_SANITIZE_NUMBER_INT);
            $datiVariazione = $geecomDb->leggiSingolaRiga("geecEc_variazioniProdotto", $idVariante);
            $prezzoVariazione = ($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") ? $datiVariazione["costo"] + ($datiVariazione["costo"] * $prodotto->getIva() / 100) : $datiVariazione["costo"];
            echo "$prezzoVariazione € <small>$suffissoIva</small>";
            break;
        case 'stampaComponentiProdotto':
            $prodotto->caricaDatiDalDatabase();
            
            $prodotto->stampaComponentiProdotto();
            break;
        case 'invertiStato':
            $prodotto->caricaDatiDalDatabase();
            if($prodotto->invertiStato()=="si") {
                echo"text-success";
            }
            else {
                echo"text-black-50";
            }
            break;
    }
    
    function creaComponente($geecomDb, $idComponente, $idPagina) {
        $datiComponente = $geecomDb->leggiSingolaRiga("geecB_componenti",$idComponente);
        
        if(($datiComponente["tipo"]=="componenteDinamicoPagine" || $datiComponente["tipo"]=="componenteStrutturaPagina") && $datiComponente["tabellaRiferimento"]!="") {
            $datiPagina     = $geecomDb->leggiSingolaRiga("geecEc_prodotti",$idPagina);
            $nomeComponente = $geecomDb->escapeString($datiComponente["nome"]);
            $queryInserimento = "INSERT INTO {$datiComponente["tabellaRiferimento"]} (`id`,`nome`) VALUES(NULL,'$nomeComponente prodotto {$datiPagina["nome"]}')";
            return $geecomDb->eseguiQueryCreazione($queryInserimento);            
        }
        else if($datiComponente["nome"]=="Immagine") {
            $immagine = new Immagine($geecomDb, 0, $idPagina, "immagineContenuto");
            return $immagine->crea();
        }
        else if($datiComponente["nome"]=="Singola risorsa") {
            $datiContenuto  = $geecomDb->leggiSingolaRiga("geecEc_prodotti",$idPagina);
            $nomeComponente = "File ".$datiContenuto["titolo"];
            $fileScaricabile = new FileScaricabile($geecomDb, 0, $nomeComponente);

            return $fileScaricabile->crea();
        }
        else {
            return 0;
        }
    }
